(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8731,        307]
NotebookOptionsPosition[      7215,        248]
NotebookOutlinePosition[      7559,        263]
CellTagsIndexPosition[      7516,        260]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"freq", "=", 
   RowBox[{"{", 
    RowBox[{"1280", ",", "1380", ",", "1410"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510634896992296*^9, 3.5106349529288893`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5106349560001965`*^9, 3.510635002484844*^9}}],

Cell[BoxData[
 RowBox[{"freq", "=."}]], "Input",
 CellChangeTimes->{{3.510635055560151*^9, 3.5106350577223673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"freq", "=", 
  RowBox[{"{", 
   RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.510635061135709*^9, 3.5106350783984346`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}]], "Output",
 CellChangeTimes->{3.510635079997595*^9, 3.510647760395031*^9, 
  3.5106569081720953`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calRTEst", "=", 
  RowBox[{"{", 
   RowBox[{"c1E", ",", "c2E", ",", "c3E"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5106350832369184`*^9, 3.5106351113587303`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c1E", ",", "c2E", ",", "c3E"}], "}"}]], "Output",
 CellChangeTimes->{3.5106351123658314`*^9, 3.510647760410631*^9, 
  3.510656908197098*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calRTWest", "=", 
  RowBox[{"{", 
   RowBox[{"c1W", ",", "c2W", ",", "c3W"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5106351149400883`*^9, 3.510635130544649*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c1W", ",", "c2W", ",", "c3W"}], "}"}]], "Output",
 CellChangeTimes->{3.5106351312737217`*^9, 3.5106477604418316`*^9, 
  3.5106569082221003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calBAOv0", "=", 
  RowBox[{"{", 
   RowBox[{"bao1v0", ",", "bao2v0", ",", "bao3v0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5106351357401686`*^9, 3.5106351689704914`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"bao1v0", ",", "bao2v0", ",", "bao3v0"}], "}"}]], "Output",
 CellChangeTimes->{3.5106351700045943`*^9, 3.510647760457432*^9, 
  3.5106569082461033`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calBAOv1", "=", 
  RowBox[{"{", 
   RowBox[{"bao1v1", ",", "bao2v1", ",", "bao3v1"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5106351809366875`*^9, 3.5106351868982835`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"bao1v1", ",", "bao2v1", ",", "bao3v1"}], "}"}]], "Output",
 CellChangeTimes->{3.5106351877323675`*^9, 3.510647760473032*^9, 
  3.510656908271106*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"caliV0", "=", 
  RowBox[{"calRTEst", "/", "calBAOv0"}]}]], "Input",
 CellChangeTimes->{{3.5106352159011836`*^9, 3.5106352792095137`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["c1E", "bao1v0"], ",", 
   FractionBox["c2E", "bao2v0"], ",", 
   FractionBox["c3E", "bao3v0"]}], "}"}]], "Output",
 CellChangeTimes->{3.5106352804596386`*^9, 3.5106477605042324`*^9, 
  3.5106569082961082`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"caliV1", "=", 
  RowBox[{"calRTWest", "/", "calBAOv1"}]}]], "Input",
 CellChangeTimes->{{3.5106352883114243`*^9, 3.510635290746668*^9}, {
  3.5106568922185*^9, 3.5106568933526134`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["c1W", "bao1v1"], ",", 
   FractionBox["c2W", "bao2v1"], ",", 
   FractionBox["c3W", "bao3v1"]}], "}"}]], "Output",
 CellChangeTimes->{3.510635291263719*^9, 3.5106477605198326`*^9, 
  3.5106569083211107`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dataV0", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"freq", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"caliV0", "[", 
       RowBox[{"[", "n", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", 
      RowBox[{"Length", "[", "freq", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5106353155721498`*^9, 3.510635383830975*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f1", ",", 
     FractionBox["c1E", "bao1v0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f2", ",", 
     FractionBox["c2E", "bao2v0"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f3", ",", 
     FractionBox["c3E", "bao3v0"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.510635386760268*^9, 3.510647760551033*^9, 
  3.510656908347113*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dataV1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"freq", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"caliV1", "[", 
       RowBox[{"[", "n", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", 
      RowBox[{"Length", "[", "freq", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.510635395911183*^9, 3.510635400627654*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f1", ",", 
     FractionBox["c1W", "bao1v1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f2", ",", 
     FractionBox["c2W", "bao2v1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f3", ",", 
     FractionBox["c3W", "bao3v1"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.510635401669759*^9, 3.510647760566633*^9, 
  3.5106569083731155`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingPolynomial", "[", 
   RowBox[{"dataV0", ",", "f"}], "]"}], " ", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.5106355722628164`*^9, 3.510635578758466*^9}, {
  3.5106479258039513`*^9, 3.510647928377984*^9}}],

Cell["\<\
c1E/bao1v0 + (f - f1)*((-(c1E/bao1v0) + c2E/bao2v0)/(-f1 + f2) + 
   ((f - f2)*(-((-(c1E/bao1v0) + c2E/bao2v0)/(-f1 + f2)) + 
      (-(c2E/bao2v0) + c3E/bao3v0)/(-f2 + f3)))/(-f1 + f3))\
\>", "Output",
 CellChangeTimes->{
  3.5106355795115414`*^9, {3.510635611380728*^9, 3.510635617842374*^9}, 
   3.5106477605978336`*^9, 3.510647864994372*^9, 3.5106479288927913`*^9, 
   3.510656908397118*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingPolynomial", "[", 
   RowBox[{"dataV1", ",", "f"}], "]"}], "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.5106477465576534`*^9, 3.5106477467916565`*^9}, {
  3.510647934368461*^9, 3.510647937145297*^9}}],

Cell["\<\
c1W/bao1v1 + (f - f1)*((-(c1W/bao1v1) + c2W/bao2v1)/(-f1 + f2) + 
   ((f - f2)*(-((-(c1W/bao1v1) + c2W/bao2v1)/(-f1 + f2)) + 
      (-(c2W/bao2v1) + c3W/bao3v1)/(-f2 + f3)))/(-f1 + f3))\
\>", "Output",
 CellChangeTimes->{{3.5106477473064632`*^9, 3.510647760629034*^9}, 
   3.510647901592441*^9, 3.5106479376757035`*^9, 3.5106569084201202`*^9}]
}, Open  ]]
},
WindowSize->{707, 761},
WindowMargins->{{19, Automatic}, {Automatic, 31}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 206, 5, 31, "Input"],
Cell[766, 27, 94, 1, 31, "Input"],
Cell[863, 30, 116, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[1004, 36, 180, 4, 31, "Input"],
Cell[1187, 42, 177, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1401, 51, 189, 4, 31, "Input"],
Cell[1593, 57, 180, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1810, 66, 188, 4, 31, "Input"],
Cell[2001, 72, 184, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2222, 81, 198, 4, 31, "Input"],
Cell[2423, 87, 191, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2651, 96, 198, 4, 31, "Input"],
Cell[2852, 102, 189, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3078, 111, 161, 3, 31, "Input"],
Cell[3242, 116, 265, 7, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3544, 128, 209, 4, 31, "Input"],
Cell[3756, 134, 263, 7, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4056, 146, 458, 13, 31, "Input"],
Cell[4517, 161, 415, 13, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4969, 179, 456, 13, 31, "Input"],
Cell[5428, 194, 417, 13, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5882, 212, 261, 5, 31, "Input"],
Cell[6146, 219, 404, 8, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6587, 232, 256, 5, 31, "Input"],
Cell[6846, 239, 353, 6, 76, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
